{{ ucfunc("put_docready_start") }}

 var objWidget = jQuery("#{{uc_id}}");
 var objSvg = objWidget.find("svg");
 var isLoop = {{loop}};

 //show svg after js load
 objSvg.css("visibility", "visible");
 objSvg.attr("aria-hidden", true);

 var mySVG{{uc_id}} = objSvg.drawsvg({
    stagger	:{{delay}},
    duration	:{{duration}},
    callback:function(){
      if(isLoop == true)
        animateSVG();
    }
 });
           	
  function animateSVG(){              
	mySVG{{uc_id}}.drawsvg('animate');
  }

  /**
  * is element in viewport
  */
  function ueIsElementInViewport(objElement) {
     var elementTop = objElement.offset().top;
     var elementBottom = elementTop + objElement.outerHeight();

     var viewportTop = jQuery(window).scrollTop();
     var viewportBottom = viewportTop + jQuery(window).height();

     if(jQuery(document).height() <= jQuery(window).height())
       return(true);

     return elementBottom > viewportTop && elementTop < viewportBottom;
  }

  function onPageScroll(){
    {% if reveal_each_time_on_scroll == "true" %}
        
      if(ueIsElementInViewport(objWidget) == false){
        var objStrokeDashOffsets = objWidget.find("[data-strokeDashOffset]");
      
        if(!objStrokeDashOffsets || objStrokeDashOffsets.length == 0)
          return(true);
        
        objStrokeDashOffsets.each(function(){
          var objPath = jQuery(this);
          var dataDash = objPath.attr("data-strokeDashOffset");
          
          objPath.css("stroke-dashoffset", dataDash);
        });
      }else{
        
      }
          
   {% endif %}
   {% if reveal_while_scrolling == "true" %}  
     var max = jQuery(document).height() - jQuery(window).height();
     var p = jQuery(window).scrollTop() / max;
     mySVG{{uc_id}}.drawsvg('progress', p);
   {% endif %}
  }
  
  {% if reveal_each_time_on_scroll == "false" %}
    {% if reveal_while_scrolling == "false" %} 
      objWidget.one('inview', function(event, isInView) {
        if(isInView == true)
        animateSVG();
      });  
    {% endif %}    
  {% else %}
   objWidget.on('inview', function(event, isInView) {
      if(isInView == true)
      animateSVG();
    });
  {% endif %}
  
   jQuery(window).on("scroll", onPageScroll)
    	
{{ ucfunc("put_docready_end") }}